﻿{$reference ExtendedNumerics.BigDecimal.dll}
uses ExtendedNumerics;
uses MathExtensions;
         
// РЕШАЕМ ЗАДАЧУ
procedure Solve01(krat, lastnum: int);
begin
   // число решений:
   var nSolution := 0;
   // макс. число решений:
   var maxSolution := 1;// 2;
   // число:
   var n := BigInteger(lastnum);
   // первая цифра слева:
   var nFirst := lastnum;
   // перенос в следующий разряд:
   var perenos := 0;

   // ищем числа в бесконечном цикле:
   while (true) do begin
      // очередная первая цифра:
      nFirst := nFirst * krat + perenos;
      perenos := nFirst div 10;
      // если очередная первая цифра
      // равна нулю, то
      // сразу вычисляем следующую
      // (перед ней):
      nFirst := nFirst mod 10;
      if (nFirst = 0) then begin
          nFirst := perenos * 10;
          perenos := 0;
      end;

      // число десятичных разрядов в текущем числе:
      var n10 := int(BigInteger.Log10(n) + 1);
      // переносим первую цифру в начало числа:
      var nShift := BigInteger(nFirst * BigInteger.Pow(10, n10));
      // добавляем к текущему числу:
      n += nShift;

      // оставляем последнюю цифру:
      if (nFirst >= 10) then
          nFirst := nFirst div 10;

      // число без последней цифры:
      var nBezLast := BigInteger(n div 10);
      // умножаем последнюю цифру:
      n10 := int(BigInteger.Log10(n));
      var nKrat := BigInteger(lastnum * BigInteger.Pow(10, n10));
      // добавляем число без последней цифры:
      var nNew := BigInteger(nKrat + nBezLast);

      if (nNew = n * krat) then begin
          nSolution += 1;
          Writeln($' Решение {nSolution}: {n} * {krat} = {nNew}');
          // достаточно решений:
          if (nSolution = maxSolution) then
              break;
       end;
   end;
   Writeln;  
end;


procedure Solve;
begin
   foreach var i in range(2,9) do begin
      var n1 := Decimal(i);
      var n2 := Decimal(19);
      var n3 := (n1 / n2).ToString.Substring(2, 18);
      Writeln(n3);
   end;
   Writeln;   
   
   foreach var i in range(3,9) do begin
      var n1 := Decimal(i);
      var n2 := Decimal(29);
      var n3 := (n1 / n2).ToString.Substring(2, 28);
      Writeln(n3);
   end;
   Writeln;     
   
   foreach var i in range(4,9) do begin
      var n1 := Decimal(i);
      var n2 := Decimal(39);
      var n3 := (n1 / n2).ToString.Substring(2, 6);
      Writeln(n3);
   end;
   Writeln;  
   
   BigDecimal.Precision := 100;
   foreach var i in range(6,9) do begin
      var n1 := BigDecimal(i);
      var n2 := BigDecimal(59);
      var n3 := (n1 / n2).ToString.Substring(2, 58);
      Writeln(n3);
   end;
   Writeln;  
   
   foreach var i in range(7,9) do begin
      var n1 := BigDecimal(i);
      var n2 := BigDecimal(69);
      var n3 := (n1 / n2).ToString.Substring(2, 22);
      Writeln(n3);
   end;
   Writeln;  
   
   foreach var i in range(8,9) do begin
      var n1 := BigDecimal(i);
      var n2 := BigDecimal(79);
      var n3 := (n1 / n2).ToString.Substring(2, 13);
      Writeln(n3);
   end;
   Writeln; 
   
   foreach var i in range(9,9) do begin
      var n1 := BigDecimal(i);
      var n2 := BigDecimal(89);
      var n3 := (n1 / n2).ToString.Substring(2, 44);
      Writeln(n3);
   end;
   Writeln;   
end;


begin
   Writeln(' Найдите число');
   Writeln;
       
   // последняя цифра:
   var lastnum := 2;
   // во сколько раз увеличивается число:
   var krat := 0;
   for var i := 2 to lastnum do begin
       krat := i;
       // число не может увеличиться
       // более чем в lastnum раз:
       if (krat > lastnum) then begin
           Writeln($' Не выполняется условие krat <= lastnum!');
           Writeln;
       end
       else Solve01(krat, lastnum); 
   end;
   Solve;
end.
